/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
// music themes, each for storing tracks
MusicTheme *mt_battle , // this is battle theme used for playing when battles
           *mt_explore, // exploring theme
           *mt_calm   ; // calm theme
/******************************************************************************/
void InitPre()
{
   App.name="Music";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;
   
   if(mt_battle=MusicThemeNew()) // create 'mt_battle' theme
   {
      *mt_battle+="../data/music/battle0.ogg"; // add "battle0.ogg" track to 'mt_battle' theme
      *mt_battle+="../data/music/battle1.ogg"; // add "battle1.ogg" track to 'mt_battle' theme
   }
   if(mt_explore=MusicThemeNew()) // create 'mt_explore' theme
   {
      *mt_explore+="../data/music/explore.ogg"; // add "explore.ogg" track to 'mt_explore' theme
   }
   if(mt_calm=MusicThemeNew()) // create 'mt_calm' theme
   {
      *mt_calm+="../data/music/calm.ogg"; // add "calm.ogg" track to 'mt_calm' theme
   }
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   if(Kb.c=='1')Music.play(mt_battle );
   if(Kb.c=='2')Music.play(mt_explore);
   if(Kb.c=='3')Music.play(mt_calm   );
   if(Kb.c=='4')Music.play(NULL      );
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);

   if(Music.theme) // if any theme playing
   {
      D.text(0,0.2,S+"song: "+Music.name());
      D.text(0,0.0,S+"time " +Music.time()+" / "+Music.length()+" length");
   }else
   {
      D.text(0,0,"No theme playing");
   }
   D.text(0,-0.2,"Press 1-battle, 2-explore, 3-calm, 4-none");
}
/******************************************************************************/
